* Restored6.sas;
title "Model selection for restored prairie data";
data RPdat;
	input site_id $ age linear ph organic TE PE TA PA exotic bc;
	* Bray-Curtis (bc) measures dissimilarity of the site vs. restoration seed mix;
	* 0 = all species in common, 1 = none in common;
	* Kaul and Wilsey (2020) say similarity in paper;
	* Apply transformations here;
	y = bc; 
	datalines;
3       5       1.29   7.33 12.28 12.25   31.77  9.94    35.61   24.05 0.982
4       6       1.39   7.93 8.54  8.69    45.50  8.89    36.80   19.87 0.898
5       14      1.21   7.90 7.11  9.31    31.83  9.11    35.52   3.68  0.791
7       5       1.24   8.03 6.28  9.42    28.26  8.00    36.48   10.25 1.000
8       3       1.28   7.67 5.69  6.61    43.13  8.00    36.48   18.00 0.998
9       10      1.12   7.97 7.92  8.97    41.19  8.00    36.48   4.50  0.712
10      8       1.04   8.10 11.04 7.19    28.99  7.22    29.60   0.90  0.623
13      2       1.22   7.53 9.43  7.06    33.20  8.94    30.46   17.70 0.892
14      6       1.43   7.80 7.81  7.42    37.36  8.94    30.46   19.70 0.841
15      8       1.10   6.70 11.44 7.72    38.73  7.94    33.94   12.97 0.646
22      24      1.33   7.70 8.94  8.11    46.30  9.06    34.67   13.65 0.994
23      6       1.06   6.47 4.31  9.81    27.33  7.89    36.66   9.20  0.676
30      4       1.47   7.80 15.56 11.89   29.17  9.72    36.09   8.33  0.994
31      5       1.29   7.60 10.03 12.25   31.77  9.94    35.61   18.08 0.894
32      5       1.36   7.53 9.07  12.25   31.77  9.94    35.61   23.85 0.953
33      7       1.06   6.77 9.46  8.22    43.67  8.28    35.84   0.20  0.474
34      9       1.02   6.53 10.21 7.81    41.78  8.28    35.84   5.67  0.503
35      6       1.06   6.47 10.47 8.53    38.07  8.28    35.84   10.14 0.684
36      9       1.03   6.33 10.29 7.81    41.78  8.28    35.84   6.33  0.632
39      14      1.02   7.30 9.39  10.50   30.26  9.72    36.27   3.57  0.589
40      15      1.12   7.63 13.47 10.72   29.43  10.50   36.02   21.71 1.000
41      6       1.02   7.57 5.98  8.69    45.50  8.67    36.47   0.09  0.315
42      4       1.28   6.77 3.78  11.89   29.17  9.72    36.09   11.35 1.000
43      4       1.34   7.93 9.06  11.89   29.17  9.72    36.09   19.10 1.000
44      6       1.42   7.57 9.12  8.69    45.50  8.89    36.80   23.30 0.924
45      9       1.11   6.20 8.62  7.94    42.92  8.56    35.24   9.08  0.660
56      5       1.04   6.97 10.81 9.42    29.81  8.72    38.35   16.75 0.967
65      9       1.22   7.37 17.36 8.06    41.38  9.06    34.23   18.00 0.808
74      12      1.02   7.27 12.30 9.33    32.16  7.89    36.66   3.17  0.739
75      6       1.08   7.30 8.03  9.81    27.33  7.89    36.66   2.22  0.634
77      9       1.32   7.93 8.03  5.94    39.49  7.17    38.30   16.43 0.965
80      10      1.27   8.13 5.82  7.56    41.58  8.17    34.42   18.28 0.959
89      11      1.02   7.40 7.26  9.19    32.51  8.39    35.63   13.00 0.735
90      3       1.18   7.57 10.06 7.61    41.01  8.39    34.67   20.60 0.926
91      6       1.02   7.00 10.90 9.03    24.98  7.72    28.71   10.30 0.680
92      9       1.05   7.07 10.37 7.81    29.42  8.94    30.46   22.72 0.865
96      14      1.15   7.33 7.11  10.67   32.95  9.00    37.38   28.40 0.955
97      5       1.00   6.73 6.22  9.64    31.49  9.50    35.36   7.53  0.916
98      3       1.36   8.10 7.82  9.28    46.10  10.39   37.25   21.40 0.937
100     17      1.30   7.87 10.42 9.17    33.58  10.72   37.59   25.03 0.970
101     3       1.26   7.93 8.64  8.56    40.66  10.72   37.59   15.37 0.772
102     11      1.25   8.10 3.61  11.69   40.36  10.00   36.28   9.57  0.972
105     13      1.05   7.93 14.54 8.53    35.57  8.00    36.48   13.77 0.718
106     10      1.02   6.97 8.19  7.64    47.79  8.00    36.48   14.25 0.624
;
run;
* Print data set;
proc print data=RPdat;
run;
* Plot y vs. x variables;
proc gplot data=RPdat;
	plot y*(age linear ph organic TE PE TA PA exotic)  / vaxis=axis1 haxis=axis1;
	symbol1 i=rl v=star c=black height=2 width=2;
	axis1 label=(height=2) value=(height=2) width=3 major=(width=2) minor=none;
	symbol1 i=rl v=star c=black;
run;
* Multiple regression;
proc reg plots=diagnostics data=RPdat;
	* Specify variables in regression model;
	model y = age linear ph organic TE PE TA PA exotic / clb stb tol vif partial;
run;
* Model selection using AICc (stepwise);
proc glmselect data=RPdat;
	* Specify variables in regression model and method of selection;
	model y = age linear ph organic TE PE TA PA exotic / selection=stepwise(select=AICC);
run;
quit;
